# -*- coding: utf-8 -*-
"""
Created on Wed May 20 22:30:05 2020

@author: tooba
"""



from keras.layers import Dense, Dropout, Flatten
from keras.layers import LSTM
from keras.models import Sequential
from keras.layers import Add,Subtract,Multiply,Average
from mlxtend.evaluate import confusion_matrix
from keras.models import Model # basic class for specifying and training a neural network
from keras.layers import GRU, Convolution2D, MaxPooling2D, Dense, Dropout, Activation, Flatten, Convolution3D, MaxPooling3D
from keras.utils import np_utils # utilities for one-hot encoding of ground truth values
import numpy as np
from keras.utils import to_categorical
import pandas as pd
from sklearn.metrics import accuracy_score
import os
from sklearn.model_selection import train_test_split
from sklearn.metrics import  classification_report
from sklearn.metrics import roc_curve, auc
from sklearn import preprocessing
import matplotlib.pyplot as plt
from Functions import accuracy_by_class , plot_confusion_matrix, PlotLearning,  Flush_results
from sklearn.model_selection import cross_val_score , cross_validate
from keras.wrappers.scikit_learn import KerasClassifier
from sklearn.metrics import matthews_corrcoef
from sklearn.model_selection import StratifiedKFold
from numpy import argmax
import datetime

plot = PlotLearning()
class_names = ['Benign','Marai','Gafgyt']
num_classes = len(class_names)
#Loading Data
dataset = pd.read_csv('MultiClass All.csv')
#print(dataset[''].unique().tolist())

# Shuffling The Final concinated Data
dataset = dataset.sample(frac=1).reset_index(drop=True)

dataset = pd.DataFrame(dataset)
X = dataset.iloc[:,:75]
X = pd.DataFrame(X)
Y = dataset.iloc[:,75:76]
Y = pd.DataFrame(Y)



#Normilization
from sklearn.preprocessing import StandardScaler
scaler = StandardScaler()
X = scaler.fit_transform(X)

#min_max_scaler = preprocessing.MinMaxScaler()
#X = min_max_scaler.fit_transform(X)


#DNN/LSTM Hybrid
#******************************************************************************
#******************************************************************************
#******************************************************************************
#******************************************************************************
#******************************************************************************

#Dimension
X = np.array(X)
X = np.reshape(X, ( X.shape[0],1, X.shape[1]))

#Setting Parameters
#Y = y_train_rnn
#X = x_train_rnn
X = np.array(X)
Y  =np.array(Y)
Traning_Time = []
Acc = []
Testing_Time = []
CM = []
TPR = []
TNR = []
NPV = []
FNR = []
FPR = []
FDR = []
FOR = []
Recall = []
Precision = []
F1 = []
MCC = []
TS = []
BM = []
MK = []
n = 0
folds = 10
kfold = StratifiedKFold(n_splits=folds, shuffle=True, random_state=0)
for train, test in kfold.split(X, Y):
    print("Fold {} of {}.   **Processing...".format(n+1,folds))


    classifier1 = Sequential()
    classifier1.add(LSTM(450, activation='relu', input_shape = (X.shape[1],X.shape[2]), return_sequences=True)) 
    classifier1.add(LSTM(400, return_sequences=True, activation='relu'))
    classifier1.add(LSTM(350, return_sequences=False, activation='relu'))
    
    classifier2 = Sequential()
    classifier2.add(GRU(450, activation='relu', input_shape = (X.shape[1],X.shape[2]), return_sequences=True))
    classifier2.add(GRU(400, return_sequences=True, activation='relu'))
    classifier2.add(GRU(350, return_sequences=False, activation='relu')) 
    mergeOut = Add()([classifier1.output, classifier2.output])
    
    
    mergeOut1 = Dense(350, activation='relu')(mergeOut)
    mergeOut3 = Dense(3, activation='softmax')(mergeOut1)
    
      
    model = Model([classifier1.input, classifier2.input], mergeOut3)
    model.compile(loss='categorical_crossentropy', optimizer='adam', metrics=['accuracy'])
    
#    Training
    t1 = datetime.datetime.now()
    score = model.fit([X[train],X[train]], to_categorical(Y[train], num_classes), batch_size = 128, epochs = 5)
    t2 = datetime.datetime.now()
    print('Total time for traning: {}'.format(t2-t1))
    Traning_Time.append(t2-t1)
    
#    Predicting
    t1 = datetime.datetime.now()
    scores = model.predict([X[test],X[test]])
    t2 = datetime.datetime.now()
    Testing_Time.append(t2-t1)
    
    #Accuracy
    acc =  accuracy_score(Y[test],scores.argmax(1))*100
    print ("Accuracy:  ", acc)
    Acc.append(acc)
    s = scores.argmax(1)
    s = pd.DataFrame(s)
    
#    Classification Report
    print(classification_report(Y[test],scores.argmax(1)))
    hold = Y[test]
    hold = pd.DataFrame(hold)

    #Confusion Matrix
    hold = Y[test]
    cm_cnn = confusion_matrix(hold,s, binary=False)
    plot_confusion_matrix(cm_cnn, classes=class_names , normalize=False,
                          title='Confusion matrix, without normalization',nn=n+1,Algo="Hybrid Hybrid",cmap="GnBu")
#    Hybrid LSTM GRU DNN
#    YlGn   BuGn          Greens    GnBu
    CM.append(cm_cnn)
    cm_cnn = np.array(cm_cnn)
    TP = cm_cnn[0][0]
    FP =  np.triu(cm_cnn).sum()-np.trace(cm_cnn)
    FN = np.tril(cm_cnn).sum()-np.trace(cm_cnn)
    TN = np.trace(cm_cnn) - TP
    
    
    #Calculating Other Parameters
    TPR.append(TP/(TP + FN))
    TNR.append(TN/(TN + FP)) 
    NPV.append(TN/(TN + FN))
    FNR.append(FN/(FN + TP))
    FPR.append(FP/(FP + TN))
    FDR.append(FP/(FP + TP))
    FOR.append(FN/(FN + TN))
    Recall.append(TP/(TP + FN))
    Precision.append(TP/(TP + FP))
    F1.append(TP/(TP + FN))
    MCC.append(matthews_corrcoef(Y[test],s))
    TS.append(TP/(TP + FN + FP))
    BM.append(TPR[n] + TNR[n] - 1)
    MK.append(Precision[n] + NPV[n] - 1)

    #ROC Curve
    #To be Executed once--------------------------------------------------------
    from scipy import interp
    from itertools import cycle
    # Compute ROC curve and ROC area for each class
    fpr = dict()
    tpr = dict()
    roc_auc = dict()
    y_test = to_categorical(Y[test], num_classes)
    y_test = np.array(y_test)
    n_classes = num_classes
    predictions = np.array(scores)
    lw=2
    #---------------------------------------------------------------------------
    for i in range(n_classes):
        fpr[i], tpr[i], _ = roc_curve(y_test[:, i], predictions[:, i])
        roc_auc[i] = auc(fpr[i], tpr[i])
    
    # Compute micro-average ROC curve and ROC area
    fpr["micro"], tpr["micro"], _ = roc_curve(y_test.ravel(), predictions.ravel())
    roc_auc["micro"] = auc(fpr["micro"], tpr["micro"])
    
    
    # Compute macro-average ROC curve and ROC area
    # First aggregate all false positive rates
    all_fpr = np.unique(np.concatenate([fpr[i] for i in range(n_classes)]))
    
    # Then interpolate all ROC curves at this points
    mean_tpr = np.zeros_like(all_fpr)
    for i in range(n_classes):
        mean_tpr += interp(all_fpr, fpr[i], tpr[i])
    
    # Finally average it and compute AUC
    mean_tpr /= n_classes
    
    fpr["macro"] = all_fpr
    tpr["macro"] = mean_tpr
    roc_auc["macro"] = auc(fpr["macro"], tpr["macro"])
    # Plot all ROC curves
    plt.figure()
#    plt.figure(figsize=(10,10))
    plt.plot(fpr["micro"], tpr["micro"],
             label='Ideal Performance-AUC = {0:0.2f}'
                   ''.format(roc_auc["micro"]),
             color='orange', linestyle=':', linewidth=4)
    
    plt.plot(fpr["macro"], tpr["macro"],
             label='Grand Average of All CLasses-AUC = {0:0.2f}'
                   ''.format(roc_auc["macro"]),
             color='green', linestyle=':', linewidth=4)
    
    colors = cycle(['olive', 'red', 'gray', 'lightgreen', 'coral', 'tan', 'yellowgreen', 'lightblue', 'coral','pink','brown','orange'])
    cls = ['Normal','FTP','SSH']
    for i, color in zip(range(n_classes), colors):
        plt.plot(fpr[i], tpr[i], color=color, lw=lw,
                 label='ROC curve of {0}'''.format(class_names[i], roc_auc[i]))
    plt.plot([0, 1], [0, 1], 'k--', lw=lw)
    plt.xlim([0, 1.0])
    plt.ylim([0, 1.05])
    plt.xlabel('False Positive Rate')
    plt.ylabel('True Positive Rate')
    plt.title('ROC for Multiclass CNN')
    plt.legend(loc="lower right")
    
    path  = os.path.dirname(os.path.realpath('All in one DNN, CNN2D, LSTM, GRU, CNN3D.py'))
    s_name = str(path + "\\Plots\\ROC\\") + "Hybrid Roc " + str(n + 1) + ".png"
    plt.savefig(s_name)
    plt.show()
#    s_name = str(path + "\\Models\\") + " Hybrid" + str(n + 1)    model.save(s_name)
    n = n + 1  

Flush_results(Traning_Time,Testing_Time,Acc,TPR,TNR,NPV,FNR,FDR,FPR,F1,MCC,FOR,Recall,Precision,TS,BM,MK)
